const express = require("express");
const app = express();
const cors = require("cors");
require("dotenv").config();
require("./src/db/connection");
const https = require("https");
const router = require("./src/routers/routes");
const path = require("path");
const fs = require("fs");
const caPath = path.resolve(__dirname, "blog.ca");
const certPath = path.resolve(__dirname, "blog.crt");
const keyPath = path.resolve(__dirname, "blog.key");

const port = 3030;

let corsOptions = {};

// corsOptions = {
//   origin: /ftv|fashiontv|flicense/,
//   methods: "GET,POST",
// };

corsOptions = {
  origin: "*",
  methods: "GET,POST",
};


// if (process.env.NODE_ENV === "production") {
//   corsOptions = {
//     origin: /ftv/,
//     methods: "GET,POST",
//   };
// } else {
//   corsOptions = {
//     origin: "*",
//   };
// }


const options = {
ca: fs.readFileSync(caPath),
cert: fs.readFileSync(certPath),
key: fs.readFileSync(keyPath),
};

app.use(cors(corsOptions));

app.use(express.json());
app.use(express.urlencoded({ extended: false }));

const uploadsRouter = express.Router();
uploadsRouter.use(express.static(path.join(__dirname, "uploads")));

app.use("/api/uploads", uploadsRouter);

app.use("/api", router);

const server = https.createServer(options, app);

server.listen(port, () => {
  console.log(`Server is listening at port ${port}`);
});

//app.listen(PORT, () => {
// console.log(`Server is listening at port ${PORT}`);
//});
