// Generated by CoffeeScript 1.4.0
var route;

route = typeof exports !== "undefined" && exports !== null ? exports : (this['route'] = {});

route.Router = (function() {

  function Router() {
    this.routes = [];
  }

  Router.prototype.add = function(expr, fn) {
    var params, pattern, routes;
    if (typeof expr === 'object') {
      routes = expr;
    } else {
      routes = {};
      routes[expr] = fn;
    }
    for (expr in routes) {
      fn = routes[expr];
      pattern = "^" + expr + "$";
      pattern = pattern.replace(/([?=,\/])/g, '\\$1');
      pattern = pattern.replace(/\[(.*?)\]/g, '[[$1]]');
      params = ['path'];
      pattern = pattern.replace(/(:|\*)([\w\d]+)/g, function(all, op, name) {
        params.push(name);
        switch (op) {
          case ':':
            return '([^/]*)';
          case '*':
            return '(.*?)';
        }
      });
      pattern = pattern.replace(/\[\[(.*?)\]\]/g, '(?:$1)?');
      this.routes.push({
        expr: expr,
        params: params,
        pattern: new RegExp(pattern),
        fn: fn
      });
    }
  };

  Router.prototype.run = function(path, context, one) {
    var args, i, m, results, value, _i, _j, _len, _len1, _ref;
    results = [];
    _ref = this.routes;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      route = _ref[_i];
      if ((m = route.pattern.exec(path))) {
        args = {};
        for (i = _j = 0, _len1 = m.length; _j < _len1; i = ++_j) {
          value = m[i];
          args[route.params[i]] = decodeURIComponent(value);
        }
        results.push(route.fn.call(context, args));
        if (one) {
          return results[0];
        }
      }
    }
    return results;
  };

  return Router;

})();
