// Generated by CoffeeScript 1.3.3
var addAndRun, assert, equal, route, vows;

assert = require('assert');

route = require('route');

vows = require('vows');

equal = assert.equal;

addAndRun = function(r, route, path) {
  var result;
  if (path == null) {
    path = route;
  }
  result = false;
  r.add(route, function() {
    return result = arguments[0];
  });
  r.run(path);
  return result;
};

if (!vows.add) {
  vows.add = function(name, batch) {
    return vows.describe(name).addBatch(batch)["export"](module);
  };
}

vows.add('router', {
  'basic routing:': {
    topic: new route.Router,
    '/test': {
      topic: function(r) {
        return addAndRun(r, '/test');
      },
      'should run': function(args) {
        return assert.isObject(args);
      }
    },
    '/:foo': {
      topic: function(r) {
        return addAndRun(r, '/:foo', '/bar');
      },
      'should run': function(args) {
        return assert.isObject(args);
      },
      'should get the right :foo value': function(args) {
        return equal(args.foo, 'bar');
      }
    },
    '/*foo': {
      topic: function(r) {
        return addAndRun(r, '/*foo', '/bar/baz');
      },
      'should run': function(args) {
        return assert.isObject(args);
      },
      'should get the right :foo value': function(args) {
        return equal(args.foo, 'bar/baz');
      }
    },
    '/*foo/:bar': {
      topic: function(r) {
        return addAndRun(r, '/*foo/:bar', '/baz/bat/quux');
      },
      'should run': function(args) {
        return assert.isObject(args);
      },
      'should get the right :foo value': function(args) {
        return equal(args.foo, 'baz/bat');
      },
      'should get the right :bar value': function(args) {
        return equal(args.bar, 'quux');
      }
    },
    '/prefix:foo': {
      topic: function(r) {
        return addAndRun(r, '/prefix:foo', '/prefixbar');
      },
      'should run': function(args) {
        return assert.isObject(args);
      },
      'should get the right :foo value': function(args) {
        return equal(args.foo, 'bar');
      }
    },
    '/path/with[/optional]/parts (without optional part)': {
      topic: function(r) {
        return addAndRun(r, '/path/with[/optional]/parts', '/path/with/parts');
      },
      'should run without the optional part': function(args) {
        return assert.isObject(args);
      }
    },
    '/path/with[/optional]/parts (with optional part)': {
      topic: function(r) {
        return addAndRun(r, '/path/with[/optional]/parts', '/path/with/optional/parts');
      },
      'should run with the optional part': function(args) {
        return assert.isObject(args);
      }
    },
    '/path/with[/:optional]/param (without optional param)': {
      topic: function(r) {
        return addAndRun(r, '/path/with[/:optional]/param', '/path/with/param');
      },
      'should run without the optional param': function(args) {
        return assert.isObject(args);
      }
    },
    '/path/with[/:optional]/param (with optional param)': {
      topic: function(r) {
        return addAndRun(r, '/path/with[/:optional]/param', '/path/with/foo/param');
      },
      'should run with the optional param': function(args) {
        return assert.isObject(args);
      },
      'should get the right :optional value': function(args) {
        return equal(args.optional, 'foo');
      }
    },
    '/path[/with]/multiple[/:optional]/parts': {
      topic: function(r) {
        return addAndRun(r, '/path/with/multiple[/:optional]/parts', '/path/with/multiple/foo/parts');
      },
      'should run': function(args) {
        return assert.isObject(args);
      },
      'should get the right :optional value': function(args) {
        return equal(args.optional, 'foo');
      }
    }
  },
  'special characters:': {
    topic: new route.Router,
    '/test?foo=bar,:name=bat': {
      topic: function(r) {
        return addAndRun(r, '/test?foo=bar,:name=bat', '/test?foo=bar,baz=bat');
      },
      'should run': function(args) {
        return assert.isObject(args);
      },
      'should get the right :name value': function(args) {
        return equal(args.name, 'baz');
      }
    }
  }
});
