const Bloglist = require("../models/blog-model");
const { v4: uuidv4 } = require("uuid");

const BlogController = {

  getBlog: async (req, res) => {
    try {
      const bloglist = await Bloglist.find().sort({ timestamp: -1 });
      res.status(200).send(bloglist);
    } catch (error) {
      res.status(400).send(error);
    }
  },

  getOneBlog: async (req, res) => {
    try {
      const blogid = req.params.blogname;
      const bloglist = await Bloglist.findOneAndUpdate(
        { slug: new RegExp(blogid.replace(/-/g, "\\-"), "i") },
        { $inc: { views: 1 } },
        { new: true }
      );
      if (!bloglist) {
        return res.status(404).json({ message: "Blog not found" });
      }

      res.status(200).json(bloglist);
    } catch (error) {
      console.error("Error fetching or updating blog:", error);
      res.status(500).json({ message: "Internal server error", error });
    }
  },

  getBlogByWeb: async (req, res) => {
    try {
      const web = req.params.website.toLowerCase(); 
      console.log('Requested website:', web);
      const blogs = await Bloglist.find({ website: web.toLowerCase() }).sort({ timestamp: -1 });
  
      if (blogs.length === 0) {
        return res.status(404).send('No blogs found for this website.');
      }
      res.json(blogs);
    } catch (error) {
      console.error(error);
      res.status(500).send("Server Error");
    }
  },
  
  addBlog: async (req, res) => {
    try {
      const bloglist = new Bloglist({
        title: req.body.title,
        slug: req.body.slug,
        subtitle: req.body.subtitle,
        thumbnail: req.body.thumbnail,
        banner: req.body.banner,
        matatitle: req.body.matatitle,
        metacontent: req.body.metacontent,
        blogcat: req.body.blogcat,
        website: req.body.website,
        views: req.body.views,
        blogcontent: req.body.blogcontent,
        author: req.body.author,
        blogid: uuidv4(),
      });
      const blogtdata = await bloglist.save();
      res.status(201).send("Blog Added");
    } catch (error) {
      res.status(400).send(error);
    }
  },

  deleteBlog: async (req, res) => {
    try {
      const id = req.params.blogid;
      const deleteBlog = await Bloglist.findOneAndDelete({ blogid: id });
      if (!deleteBlog) {
        console.error("Blog not found");
        return res.status(404).json({ error: "Blog not found" });
      }
      res
        .status(200)
        .json({ message: "Blog deleted successfully", data: deleteBlog });
    } catch (error) {
      res.status(500).json({ error: "Internal Server Error" });
    }
  },
};

module.exports = BlogController;
