const express = require("express");
const Catlist = require("../models/cat-model");
const { v4: uuidv4 } = require("uuid");

const CategeriesController = {
  getCat: async (req, res) => {
    try {
      const catlist = await Catlist.find();
      res.status(200).send(catlist);
    } catch (error) {
      res.status(400).send(error);
    }
  },

  addCat: async (req, res) => {
    try {
      const catlist = new Catlist({
        name: req.body.name,
        website: req.body.selectedWebsite,
        catid: uuidv4(),
      });
      const weblistdata = await catlist.save();
      res.status(201).json({ message: "Categeries Added", data: weblistdata });
    } catch (error) {
      res.status(400).send(error);
    }
  },

  deleteCat: async (req, res) => {
    try {
      const id = req.params.catid;
      const deletedCat = await Catlist.findOneAndDelete({ catid: id });
      if (!deletedCat) {
        console.error("Categeries not found");
        return res.status(404).json({ error: "Categeries not found" });
      }
      res
        .status(200)
        .json({ message: "Categeries deleted successfully", data: deletedCat });
    } catch (error) {
      res.status(500).json({ error: "Internal Server Error" });
    }
  },
  
};

module.exports = CategeriesController;
