const path = require("path");
const Imagelist = require("../models/imagestorage-model");
const multer = require("multer");
const { v4: uuidv4 } = require("uuid");

const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, "uploads/")
  },
  filename: (req, file, cb) => {
    cb(null, Date.now() + "-" + file.originalname)
  },
})

const uploadStorage = multer({ storage: storage })

async function uploadImage(req, res) {
  try {
    if (!req.file) {
      return res.status(400).send("No file uploaded");
    }

    const newFilePath = req.file.path;

    const newImage = new Imagelist({
      imageName: req.file.originalname,
      imageUrl: newFilePath,
      imageid: uuidv4(),
    });

    const imageData = await newImage.save();

    res.status(200).json({
      message: "File uploaded and data saved to MongoDB",
      file: {
        filename: req.file.originalname,
        path: newFilePath,
        mimetype: req.file.mimetype,
        size: req.file.size,
      },
      mongoDocument: imageData,
    });
  } catch (error) {
    console.error("Image upload error:", error);
    res.status(500).send("Internal server error");
  }
}

module.exports = uploadImage;
