const express = require("express");
const Websitelist = require("../models/web-model");
const { v4: uuidv4 } = require("uuid");

const WebsiteController = {
  getList: async (req, res) => {
    try {
      const weblist = await Websitelist.find();
      if (weblist == "") {
        res.status(204).send("No Data Found");
      } else {
        res.status(200).send(weblist);
      }
    } catch (error) {
      res.status(400).send(error);
    }
  },
  
  addWeb: async (req, res) => {
    try {
      const weblist = new Websitelist({
        name: req.body.name,
        websiteid: uuidv4(),
      });
      const weblistdata = await weblist.save();
      console.log(weblistdata);
      res.status(201).send("Website Added");
    } catch (error) {
      res.status(400).send(error);
    }
  },

  deleteWeb: async (req, res) => {
    try {
      const id = req.params.websiteid;
      const deletedWeb = await Websitelist.findOneAndDelete({ websiteid: id });
      if (!deletedWeb) {
        console.error("Website not found");
        return res.status(404).json({ error: 'Website not found' });
      }
      res.status(200).json({ message: 'Website deleted successfully', data: deletedWeb });
    } catch (error) {
      res.status(500).json({ error: 'Internal Server Error' });
    }
  },
};

module.exports = WebsiteController;
