const mongoose = require("mongoose");

const blogSchema = new mongoose.Schema({
  blogid: {
    type: String,
    unique: true,
  },
  title: {
    type: String,
    required: true,
  },
  slug: {
    type: String,
    required: true,
  },
  subtitle: {
    type: String,
  },
  thumbnail: {
    type: String,
    required: true,
  },
  banner: {
    type: String,
    required: true,
  },
  matatitle: {
    type: String,
  },
  metacontent: {
    type: String,
  },
  timestamp: {
    type: Date,
    default: Date.now,
  },
  blogcontent: {
    type: String,
    required: true,
  },
  blogcat: {
    type: String,
    required: true,
  },
  views: {
    type: Number,
    default:0,
  },
  website: {
    type: String,
    required: true,
  },
  author: {
    type: String,
    required: true,
  },
});



const Bloglist = new mongoose.model("blogs", blogSchema);

module.exports = Bloglist;
