const express = require("express");
const router = express.Router();
const WebsiteController = require("../controllers/website");
const CategeriesController = require("../controllers/categorie");
const uploadImage = require("../controllers/images");
const BlogController = require("../controllers/blogs");
const multer = require("multer");
const upload = multer({ dest: "uploads/" });
const { getassmethod } = require("../controllers/auth");
const { checkToken } = require("../auth/token_validation");

router.get("/", (req, res) => {
  res.send("Hello World!");
});

//Get token

router.post("/getaccesstoken", getassmethod);

// For Websites

router.get("/websites", WebsiteController.getList);
router.post("/websites", checkToken, WebsiteController.addWeb);
router.delete("/websites/:websiteid", checkToken, WebsiteController.deleteWeb);

//For Categories

router.get("/categeries", CategeriesController.getCat);
router.post("/categeries", checkToken, CategeriesController.addCat);
router.delete("/categeries/:catid", checkToken, CategeriesController.deleteCat);

//For Blogs
router.get("/blogs", BlogController.getBlog);
router.get("/blogs/website/:website", BlogController.getBlogByWeb);
router.get("/blogs/:blogname", BlogController.getOneBlog);
router.post("/blogs", checkToken, BlogController.addBlog);
router.delete("/blogs/:blogid", checkToken, BlogController.deleteBlog);


// For Images
router.post("/upload", upload.single("file"), uploadImage);

module.exports = router;
